/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio.model.mapping;

import filenet.vw.toolkit.design.visio.images.VWImageLoader;
import filenet.vw.toolkit.design.visio.model.Master;
import filenet.vw.toolkit.design.visio.model.Shape;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.IVWSortItem;
import javax.swing.ImageIcon;

public class VWMappingItem
implements IVWSortItem {
    private static final ImageIcon ICON_MAPPED = VWImageLoader.createImageIcon("greenCheck16.gif");
    private static final ImageIcon ICON_WARNING = VWImageLoader.createImageIcon("warning16.gif");
    private Shape m_visioShape = null;
    private String m_shapeNameU = null;
    private String m_shapetext = null;
    private String m_designerObjectName = VWResource.s_unmapped;
    private boolean m_bisModified = false;

    protected VWMappingItem(Shape visioShape) {
        this.m_visioShape = visioShape;
    }

    protected VWMappingItem(String shapeName, String shapeText, String fnObjectName) {
        this.m_shapeNameU = shapeName;
        this.m_shapetext = shapeText;
        if (fnObjectName != null) {
            this.m_designerObjectName = fnObjectName;
        }
    }

    public String getDesignerObjectName() {
        return this.m_designerObjectName;
    }

    public void setDesignerObjectName(String newValue) {
        this.m_designerObjectName = newValue;
    }

    public ImageIcon getStatusIcon() {
        if (this.isMapped()) {
            return ICON_MAPPED;
        }
        return ICON_WARNING;
    }

    public String getVisioShapeDisplayName() {
        Master shapeMaster;
        if (this.m_visioShape != null && (shapeMaster = this.m_visioShape.getMaster()) != null && shapeMaster.getDisplayName() != null) {
            return shapeMaster.getDisplayName();
        }
        return this.getVisioShapeNameU();
    }

    public String getVisioShapeNameU() {
        if (this.m_visioShape != null) {
            return this.m_visioShape.getNameU();
        }
        return this.m_shapeNameU;
    }

    public String getVisioShapeText() {
        if (this.m_visioShape != null) {
            return this.m_visioShape.getText();
        }
        return this.m_shapetext;
    }

    public boolean isModified() {
        return this.m_bisModified;
    }

    public void setIsModified(boolean bIsModified) {
        this.m_bisModified = bIsModified;
    }

    public boolean isMapped() {
        return this.m_designerObjectName != null && VWStringUtils.compare(this.m_designerObjectName, VWResource.s_unmapped) != 0;
    }

    public static String getCanonicalName(String nameU, String text) {
        StringBuffer buffer = new StringBuffer(nameU);
        if (text != null) {
            buffer.append("-" + text);
        }
        return buffer.toString();
    }

    public String getName() {
        return VWMappingItem.getCanonicalName(this.getVisioShapeNameU(), this.getVisioShapeText());
    }

    protected Shape getVisioShape() {
        return this.m_visioShape;
    }

    protected void setVisioShape(Shape visioShape) {
        this.m_visioShape = visioShape;
    }
}

